   Copyright (C) 1989, 1992, 1993 Aladdin Enterprises.  All rights reserved.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.

- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

*****************************************************
* This file describes version 2.6.1 of Ghostscript. *
*****************************************************

********
******** An overview of Ghostscript ********
********

Ghostscript is the name of a set of software that provides:

	- An interpreter for the PostScript (TM) language, and

	- A set of C procedures (the Ghostscript library) that
implement the graphics capabilities that appear as primitive
operations in the PostScript language.

The primary contact for Ghostscript is:

	Aladdin Enterprises
	P.O. box 60264
	Palo Alto, CA 94306
	voice (415)322-0103
	fax (415)322-1734
	...{uunet,decwrl}!aladdin!ghost
	ghost@aladdin.com

L. Peter Deutsch, president of Aladdin Enterprises, was the original
creator, and is the primary developer and maintainer, of Ghostscript.
Aladdin Enterprises owns the copyright in Ghostscript; Ghostscript is
distributed with the GNU General Public License, and is also available for
commercial licensing.

The Ghostscript language interpreter and library are written entirely
in C, with some assembly-language accelerators for MS-DOS platforms.
Currently, Ghostscript is known to run on the following platform
families:

	- IBM PC and compatibles with EGA, VGA, SuperVGA, or compatible
	  graphics under MS-DOS 3.1, 3.3, or 5.0, with or without
	  Microsoft Windows 3.0 or 3.1;

	- IBM PC and compatibles under OS/2 2.0 and 2.1;

	- A wide variety of Unix systems using X Windows version 11,
	  release 3, 4, and 5, including Sun-3, Sun-4, Sun-386i,
	  Sun SPARCStation 1 and 2; generic 80386 machines running 386/ix,
	  ISC Unix, and SCO Unix; H-P 9000/300 and 9000/800;
	  DECStation 2100 and 3100; VAX running Ultrix; Sequent Symmetry;
	  Convex C1 and C2; Tektronix 4300; SGI Iris Indigo;

	- Sun workstations (Sun-3, SPARC, Sun-386i) running SunView;

	- VAX, VMS with X11R3/4/5 and gcc.  (Ghostscript currently is
	not compatible with the DEC C compilers, because they
	interpret the ANSI C standard in a way different from all
	other known compilers.)

It is very likely that Ghostscript will run under other versions of
MS-DOS, and other versions of Unix that support X11, but it has not
been tested in these environments.  Ghostscript does NOT run well on
PC-compatibles with Hercules display cards: text and graphics output
interfere with each other.

Other platforms
---------------

Ghostscript has also been ported a number of platforms by users, who
are willing to be contacted regarding problems on those specific
platforms:

	- For information on a port to the Apple Macintosh, contact
	Martin Fong (mwfong@nisc.sri.com).  (Aladdin Enterprises will be
	offering a Macintosh port in early 1993.)

	- For information on a port to the Acorn Archimedes, contact
	David Elworthy (David.Elworthy@cl.cam.ac.uk).

	- For information on two different ports to Win-OS/2, contact
	Gershon Elber (gershon@gr.cs.utah.edu) and/or Jim Yang
	(jyang@daedalus.caltech.edu).

	- For information on a port to the Atari ST, contact Tim
	Gallivan (timg@landau.ph.utexas.edu).

********
******** Related work
********

There are two freely available X Windows screen previewers based on
Ghostscript: Ghostview and GSPreview.  For information on Ghostview,
contact Tim Theisen (ghostview@cs.wisc.edu).  For information on
GSPreview, contact Richard Hesketh (rlh2@ukc.ac.uk).

There is a freely available MS Windows screen previewer based on
Ghostscript, called Ghostview for Windows.  For information on Ghostview
for Windows, contact Russell Lang (rjl@monu1.cc.monash.edu.au).

A set of patches and additions for Kanji capability for Ghostscript
version 2.4.1 is available for anonymous FTP from
ftp.cs.titech.ac.jp:GNU/gs241j11.tar.Z.  For more information, contact
Mr. Norio Katayama (katayama@nacsis.ac.jp).

Thomas Wolff (wolff@inf.fu-berlin.de) is working on extending the
Hershey fonts to include international characters.

********
******** Documentation overview ********
********

All the file names mentioned in the documentation, except for README,
are in lower case, which is the usual convention for Unix systems.
On MS-DOS systems, all file names are actually upper-case.

When you receive Ghostscript, you should start by reading:

> README - this file.

> readme.doc - information about problems and major changes new
features in the current release.

If you have used a previous release of Ghostscript, you probably
should also read any more recent sections of:

> NEWS - a complete, detailed history of changes in the most recent
Ghostscript releases.

Especially for new users
------------------------

If you are a new user of Ghostscript, you should read:

> use.doc - information about to install and use Ghostscript.  This
information is also contained in gs.1 - a `man' page for Ghostscript.

> devices.doc - more detailed information about specific devices that
Ghostscript knows about.

> ps2epsi.doc, unix-lpr.doc - more detailed information about some of
the shell scripts and batch files distributed with Ghostscript.

If you are going to compile Ghostscript, rather than just use an
executable you got from somewhere, you should read:

> make.doc - how to install, compile and link Ghostscript.

If you run into any questions, or if you are going to be using
Ghostscript extensively, you should at least skim, and probably
eventually read:

> fonts.doc - information about the fonts distributed with
Ghostscript, including how to add or replace fonts.

> language.doc - A description of the Ghostscript language, and its
differences from the documented PostScript language.

> psfiles.doc - information about the .ps files distributed with
Ghostscript (other than fonts).

Especially for developers
-------------------------

If you are going to be writing a new driver for Ghostscript, you
should read:

> drivers.doc - the interface between Ghostscript and device drivers.

> xfonts.doc - the interface between Ghostscript and platform-supplied
fonts.  (Read drivers.doc first.)

If you are considering distributing Ghostscript in conjunction with a
commercial product, you should read the COPYING license carefully,
and you should also read:

> commprod.doc - additional clarification of the circumstances under
which Ghostscript can be distributed with a commercial product.

Other files
-----------

> ps2epsi.doc - documentation for the PostScript to EPSI conversion
utility.

> helpers.doc - a note of thanks to all the people who have helped with
Ghostscript development.

> hershey.doc - information about the Hershey fonts, which are the
basis of some of the Ghostscript fonts.

> history.doc - a history of changes in older Ghostscript release.

> humor.doc - a humorous comment on Ghostscript contributed by a user.

> lib.doc - information about the Ghostscript library.

> unix-lpr.doc - information about how to integrate Ghostscript with
Unix printer spooling.

********
******** Trouble reporting ********
********

Aladdin Enterprises doesn't have the resources to respond to questions
from general users of Ghostscript.  If you have problems with Ghostscript,
and you have access to Usenet news, we suggest you post your question to
gnu.ghostscript.bug.  There are hundreds of Ghostscript user sites all
over the world, and often another user will be able to help you.  (If you
have access to Internet mail, but not news, send e-mail to
bug-ghostscript@prep.ai.mit.edu.)  If you are having trouble with a
specific device driver, look in the file devs.mak and see if it is a
user-maintained driver.  If so, please contact the person listed there
directly; please do not contact Aladdin Enterprises regarding
user-maintained drivers.

Aladdin Enterprises does want Ghostscript to be of high quality, so if you
have been running Ghostscript and encounter a problem, we will consider
investigating it if you meet all the following criteria:

	- You are using the most recent version of Ghostscript.

	- You obtained Ghostscript directly from Aladdin Enterprises,
	or from a GNU distribution site on the Internet (i.e., not from a
	bulletin board system or a commercial system such as CompuServe or
	GEnie).

	- You have installed Ghostscript successfully, and used it
	successfully on other input data.

	- Your problem is reproducible, and you can send us the input
	data that evokes it (by e-mail, anonymous FTP, or PC diskette).
	(But please do not send anything unless we ask you for it.)

	- Your bug report tells us what hardware, operating system,
	window system, and C compiler you are using.

Bug reports that include suggested fixes are especially welcome.

As time permits, Aladdin Enterprises will also respond to e-mail from
the following classes of users:

	- Beta testers who have actually given us at least one report on
	some beta version supplied to them.

	- People developing drivers that are for, or applications that
	are based on, Ghostscript and that will be made freely available.

	- People who express serious interest in commercial licensing
	of Ghostscript.

	- Commercial licensees.

Given the choice between the Internet and the UUCP address, remember
that the Internet is not to be used for general commercial traffic:
if you aren't sure whether you or your organization can use the
Internet, use UUCP.

Aladdin Enterprises owns or has access to the following hardware and
software:

	80486 PC, MS-DOS 5.0, Microsoft Windows 3.1;
	  Borland C++ 3.1 (and several older versions);
	  color SuperVGA display; Epson-compatible printer
	  (the printer also is compatible with the IBM Proprinter);
	  various H-P printers; Canon BubbleJet.

	SPARCstation, SunOS 4.1, cc and gcc, X11R5 and SunView;
	  both monochrome and color displays.

	DECstation, Ultrix.

If your problem turns out to be specific to some other hardware or
software configuration, it may take longer to track down, since we
will have to rely on other users to help.

If you call on the phone, you will usually be talking to an answering
machine.  In this case, please leave a message with your name and
phone number and the best time for us to return the call.

********
******** Things you can do to help ********
********

There are some projects that users could do that are somewhat
decoupled from the main body of the code, and that would help improve
Ghostscript:

	- Since Aladdin Enterprises doesn't have ready access to Unix
systems, someone else is needed to take responsibility for texinfo and/or
man page documentation for Ghostscript.  What this would involve is
updating this documentation during the beta test period for each release,
and sending it to Aladdin to be included in the final fileset.  (Aladdin
would continue to supply the plain-text documentation as it currently
exists.)

	- Ghostscript needs some good, free, Type 1 (outline) fonts.  Karl
Berry is working on this, but it might go faster if he got some
knowledgeable assistance.  Contact karl@cs.umb.edu if you want to help
with this.

	- Adobe has donated the specification of the Display PostScript C
API to the X distribution.  Implementing this API for Ghostscript might
make Ghostscript a lot more useful, since it would then be "plug
compatible" with Display PostScript in an important way.  Contact
ghost@aladdin.com if you would like to help with this.

	- On gray-scale displays, it might be worthwhile implementing
anti-aliased fonts.  To do this, one would modify the renderer so that it
cached a high-resolution bitmap, and then did the anti-aliasing as it
copied the bitmap to the device.  This would allow simulating
fractional-pixel positioning, which is one of the great benefits of
anti-aliased fonts.  Contact ghost@aladdin.com if this is of interest to
you.

	- Ghostscript currently runs on Microsoft Windows 3.0 and 3.1 on
top of MS-DOS, but does not yet run on Windows NT.  If you are interested
in helping port Ghostscript to run on Windows NT (presumably by getting it
to run using Win32/Win32s), please contact ghost@aladdin.com.

********
******** Authors ********
********

Ghostscript was originally created, and is primarily developed and
maintained, by L. Peter Deutsch, President of Aladdin Enterprises.

Special thanks are due to Russell Lang, for the gsview (Ghostview for
Microsoft Windows) program and for contributing most of the code for the
Microsoft Windows environment, and to Tim Theisen, for the Ghostview
program for X Windows and for major contributions to the code for the X
Windows environment.

The file helpers.doc contains a list of all the many other people who have
contributed significantly to improving Ghostscript.

- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

PostScript is a trademark of Adobe Systems, Incorporated.
