# Copyright (c) 1993 by Sanjay Ghemawat
#############################################################################
# File Dialog
#
# Commands
#
#	get_file_name <leader> <title> <message> <var> [<init>]
#		Get file name from user.  The name is stored in <var>.
#		Returns true iff user does not cancel operation.

# Hidden global variables
#
#	file_box		File selector window
#	file_done		Is file interaction finished

set file_box {}
set file_done 0

proc get_file_name {leader title message var {init {}}} {
    file_make

    set result [file_interact $leader $title $message $init]
    if $result {
	global file_box

	upvar $var returnVar
	set returnVar [$file_box filename]
    }
    return $result
}

proc file_make {} {
    global file_box file_done
    if [string compare $file_box {}] {return}

    set f .file_dialog
    toplevel $f -class Dialog
    wm title $f Dialog
    wm protocol $f WM_DELETE_WINDOW {set file_done 0}

    frame $f.top -relief raised -bd 1
    frame $f.mid -relief raised -bd 1

    set file_box [FileSelector $f.box]
    message $f.text -aspect 400 -text {Uninitialized message}
    make_buttons $f.bot 1 {
	{Cancel		{set file_done 0}}
	{Okay		{set file_done 1}}
    }

    pack $f.text -in $f.top -side top -expand 1 -fill both -padx 5m -pady 5m
    pack $f.box -in $f.mid -side top -expand 1 -padx 5m -pady 5m

    pack $f.top -side top -expand 1 -fill both
    pack $f.mid -side top -expand 1 -fill both
    pack $f.bot -side top -expand 1 -fill both

    bind $f.box.entry <Control-c> {set file_done 0}
    bind $f.box.entry <Return> {set file_done 1}
    bind $f.box.children.box <Double-Button-1> {file_done_check}

    wm withdraw $f
    update
}

proc file_interact {leader title message init} {
    global file_done file_box
    set f .file_dialog

    # Fix dialog contents
    $f.text configure -text $message
    wm title $f $title
    if [string compare $init {}] {
	$file_box goto $init
    }

    # Run dialog
    set file_done -1
    dialog_run $leader $f $f.box.entry file_done

    return $file_done
}

proc file_done_check {} {
    global file_box file_done

    if ![file isdirectory [$file_box filename]] {
	set file_done 1
    }
}
