/* tr_fill.c  93.12.21
 * Copyright 1983-1992   Albert Davis
 * Fill working matrix for transient and dc analysis
 * Returns convergence status.
 */
#include "ecah.h"
#include "branch.h"
#include "mode.h"
#include "status.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	int	tr_fill(void);
	int	tr_fill_rl(branch_t*);
	int	tr_fill_ll(branch_t**);
	void	tr_unfill_rl(branch_t*);
/*--------------------------------------------------------------------------*/
extern struct status stats;
/*--------------------------------------------------------------------------*/
/* tr_fill:  process netlist, evaluate models, fill matrix, etc
 * clears matrix, re-fills it, checks for convergence
 * does not evaluate matrix
 */
int tr_fill(void)
{
 int converged;

 time_start(&(stats.load));
 converged = tr_fill_rl(firstbranch_dev());
 time_stop(&(stats.load));
 return converged;
}
/*--------------------------------------------------------------------------*/
/* tr_fill_rl: evaluate a list of models, fill matrix
 * evaluates a list (or sublist), checks convergence, etc.
 * argument is the head of the netlist.
 * recursively called to evaluate subcircuits
 */
int tr_fill_rl(branch_t *brh)
{
 int converged;
 const branch_t *stop;

 converged = YES;
 if (exists(brh)){
    stop = brh;
    do {
       converged &= dotr_branch(brh);
    } while (brh=nextbranch_dev(brh),  brh != stop);
 }
 return converged;
}
/*--------------------------------------------------------------------------*/
/* tr_fill_ll: linear list version of tr_fill_rl
 */
int tr_fill_ll(branch_t **bl)
{
 int converged;
 branch_t *brh;

 converged = YES;
 if (bl){
    for (brh = *bl;  exists(brh);  ++bl){
       converged &= dotr_branch(brh);
    }
 }
 return converged;
}
/*--------------------------------------------------------------------------*/
/* tr_unfill_rl: remove evaluate a list of models from the matrix
 * recursively called to unevaluate subcircuits
 */
void tr_unfill_rl(branch_t *brh)
{
 const branch_t *stop;
 if (exists(brh)){
    stop = brh;
    do {
       untr_branch(brh);
    } while (brh=nextbranch_dev(brh),  brh != stop);
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
