/* tr.h  94.06.23
 * Copyright 1983-1992   Albert Davis
 */
#define TR_H

typedef struct {
   double start;	/* sweep start time */
   double stop;		/* sweep stop time */
   double step;		/* printed step size */
   double dtmax;	/* max internal step size (step / skip) */
   double dtmin;	/* min internal step size */
   double dtratio;	/* ratio of max/min dt */
   int skip;		/* fixed step size: internal steps per external */
   int cold;		/* flag: start time=0, all voltages=0 */
   int cont;		/* flag: continue from previous run */
   int echo;		/* flag: echo the input when using input data file */
   int field;		/* which field to use in input file */
   int trace;		/* enum: show extended diagnostics */
   double time0;	/* time now */
   double time1;	/* time at previous time step */
   double approxtime;	/* guess at best time for next step */
   int control;		/* why this time (enum) */
   int printnow;	/* flag: print this step */
} transient_t;

typedef struct {
   double start;	/* user start frequency */
   double stop;		/* user stop frequency */
   double step;		/* fft frequecncy step */
   transient_t tr;	/* the underlying transient analysis */
} fourier_t;
