/* fft.c  94.07.23
 * Copyright 1983-1992   Albert Davis
 * fast fourier transform
 */
#include "ecah.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	fft(complex_t*,int,int);
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
void fft(complex_t *x, int n, int inv)
{
 complex_t w, t;
 int s, nxp, nxp2, m;
 double wpwr, arg;
 
 s = (inv) ? 1 : -1;
 for (nxp=n  ;	(nxp2=nxp/2) > 0  ;  nxp=nxp2){
    wpwr = kPIx2 / nxp;
    for (m=0 ;	 m<nxp2 ;  m++){
       register int j1, j2;
       arg = m * wpwr;
       w.x =	cos(arg);
       w.y = s*sin(arg);
       for (j1=m  ;  j1+nxp-m<=n  ;  j1+=nxp){
	  j2 = j1 + nxp2;
	  t.x = x[j1].x - x[j2].x;
	  t.y = x[j1].y - x[j2].y;
	  x[j1].x += x[j2].x;
	  x[j1].y += x[j2].y;
	  x[j2].x = t.x * w.x - t.y * w.y;
	  x[j2].y = t.y * w.x + t.x * w.y;
       }
    }
 }
 /* unscramble */
 {
    register int j, k;
    int i;
    for (i=j=0 ;  i<n-1 ;  i++, j+=k){
       if (i<j){
	  t	 = x[j];
	  x[j] = x[i];
	  x[i] = t;
       }
       for (k=n/2 ;  k<=j ;  k/=2)
	  j -= k;
    }
 }
 /* fix level */
 {
    if (!inv){
       register int i;
       register int nn;
       nn = n;
       for ( i=0 ;  i<nn ;  i++ ){
	  x[i].x /= nn;
	  x[i].y /= nn;
       }
    }
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
