/* d_dot.c  94.12.09
 * Copyright 1983-1994   Albert Davis
 * processing for DOTCARD netlist item (pseudo-device)
 */
#include "ecah.h"
#include "argparse.h"
#include "branch.h"
#include "error.h"
#include "mode.h"
#include "types.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
static 	void    parse_dotcard(branch_t*,const char*,int*);
static	void	parse_dot_generic(branch_t*,const char*);
static	void	parse_dot_model(branch_t*,const char*,int*);
static 	void	print_dotcard(const branch_t*,int,int);
/*--------------------------------------------------------------------------*/
extern int run_mode;
/*--------------------------------------------------------------------------*/
functions_t dev_dotcard = {
   (generic_t*)NULL,	/* x */
   sizeof(functions_t),	/* ssize */
   sizeof(branch_t),	/* elementsize */
   (functions_t*)NULL,	/* super */
   0, 			/* numnodes */
   rnTEXT,		/* refnode */
   NO,			/* isdevice */
   create_std,		/* create */
   copy_std,		/* copy */
   parse_dotcard,	/* parse */
   print_dotcard,	/* print */
   NULL,		/* expand */
   NULL,		/* probe */
   NULL,		/* tr_probe */
   NULL,		/* ac_probe */
   NULL,		/* xprobe */
   NULL,		/* dotr */
   NULL,		/* untr */
   NULL,		/* doac */
   NULL,		/* trfun1 */
   NULL,		/* trfun0 */
   NULL,		/* acfun */
   NULL,		/* tr_guess */
   NULL,		/* tr_advance */
   NULL			/* tr_review */
};
/*--------------------------------------------------------------------------*/
static void parse_dotcard(branch_t *brh, const char *cmd, int *cnt)
{
 (*cnt)++;
 setmatch(cmd,cnt);
 if (rematch("MODEL") || rematch("SUBCKT")){
    parse_dot_model(brh,cmd,cnt);
 }else{
    parse_dot_generic(brh,cmd);
    if (run_mode != rIGNORE)
       cmdproc(&cmd[*cnt]);
 }
}
/*--------------------------------------------------------------------------*/
/*ARGSUSED*/
static void parse_dot_generic(branch_t *brh, const char *cmd)
{
 size_t maxlen = sizeof(branch_t) - (&(brh->label[0]) - (char*)brh);
 (void)strncpy(brh->label, cmd, maxlen);
}
/*--------------------------------------------------------------------------*/
static void parse_dot_model(branch_t *brh, const char *cmd, int *cnt)
{
 branch_t *newbrh;
 int labelcnt;

 newbrh = brh;
 labelcnt = *cnt;
 (void)ctostr(cmd, cnt, brh->label, LABELEN, TOKENTERM);
 setmatch(cmd,cnt);
      if (rematch("D"	))  newbrh = create_branch(&model_diode);
 else if (rematch("NPn"	))  newbrh = create_branch(&model_bjt);
 else if (rematch("PNp"	))  newbrh = create_branch(&model_bjt);
 else if (rematch("NJf"	))  syntax_msg(cmd,cnt,bWARNING);
 else if (rematch("PJf"	))  syntax_msg(cmd,cnt,bWARNING);
 else if (rematch("NMos"))  newbrh = create_branch(&model_mos);
 else if (rematch("PMos"))  newbrh = create_branch(&model_mos);
 else if (rematch("Logic")) newbrh = create_branch(&model_logic);
 else if (rematch("SW"))    newbrh = create_branch(&model_vswtch);
 else if (rematch("CSW"))   newbrh = create_branch(&model_vswtch);
 else			    newbrh = create_branch(&model_subckt);
 if (newbrh != brh){
    *brh = *newbrh;
    if (newbrh->n == newbrh->nodes)
       brh->n = brh->nodes;    
    free((void*)newbrh);
    parse_branch(brh,cmd,&labelcnt);
 }
}
/*--------------------------------------------------------------------------*/
static void print_dotcard(const branch_t *brh, int where, int detail)
{
 mprintf(where, "%s\n", brh->label);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
