/* dev_bjt.h  11/19/91
 * Copyright 1983-1992   Albert Davis
 * data structures and defaults for bjt model.
 */
#define qDEFMOD_modelname	"-d-"
#define qDEFMOD_js	1e-14
#define qDEFMOD_rs	0.0
#define qDEFMOD_n	1.0
#define qDEFMOD_tt	0.0
#define qDEFMOD_cj	0.0
#define qDEFMOD_pb	1.0
#define qDEFMOD_mj	0.5
#define qDEFMOD_eg	1.11
#define qDEFMOD_xti	3.0
#define qDEFMOD_kf	0.0
#define qDEFMOD_af	1.0
#define qDEFMOD_fc	0.5
#define qDEFMOD_bv	0.0	/* infinity */
#define qDEFMOD_ibv	1e-3
#define qDEFMOD_cjsw	0.0
#define	qDEFMOD_mjsw	0.33
#define qDEFMOD_fcpb	(qDEFMOD_fc * qDEFMOD_pb)

#define qDEFDEV_modelname	qDEFMOD_modelname
#define qDEFDEV_is	NOT_INPUT
#define qDEFDEV_rs	NOT_INPUT
#define qDEFDEV_cj	NOT_INPUT
#define qDEFDEV_cjsw	NOT_INPUT
#define	qDEFDEV_area	1.0
#define qDEFDEV_perim	0.0
#define	qDEFDEV_ic	NOT_INPUT
#define qDEFDEV_off	NO

struct bjt {
   generic_t	*x;		/* (not used)				*/
   size_t	ssize;
   const struct qmod *m;	/* process dependent model params	*/
   char 	modelname[LABELEN+1];
   double	is;		/* saturation current			*/
   double	rs;		/* series resistance			*/
   double	cj;		/* zero bias jct capacitance		*/
   double	cjsw;		/* zero bias sidewall capacitance	*/
   double	area;		/* area factor				*/
   double	perim;		/* perimeter factor			*/
   double	ic;		/* initial voltage			*/
   int		off;		
   double	isat;		/* is adjusted for temp, etc.		*/
   struct {
      unsigned	is:1,
      		rs:1,
		cj:1,
		cjsw:1;
   } calc;
		
};

struct qmod {
   generic_t	*x;		/* owned expansion stuff (not used)	*/
   size_t	ssize;		/* spice2 parameters			*/
   double	js;   /* is  */	/* saturation current (per area)	*/
   double	rs;		/* ohmic resistance (per area)		*/
   double	n;		/* emission coefficient			*/
   double	tt;		/* transit time				*/
   double	cj;   /* cjo */	/* zero-bias jct capacitance (per area)	*/	
   double	pb;   /* vj  */	/* junction potential			*/
   double	mj;   /* m   */	/* grading coefficient			*/
   double	eg;		/* activation energy			*/
   double	xti;		/* saturation-current temp. exp.	*/
   double	kf;		/* flicker noise coefficient		*/
   double	af;		/* flicker noise exponent		*/
   double	fc;		/* coef for fwd bis depl cap formula	*/
   double	bv;		/* reverse breakdown voltage		*/
   double	ibv;		/* current at reverse breakdown		*/
   				/* non-spice extensions			*/
   double	cjsw;		/* zero bias sidewall cap (per perim.)	*/
   double	mjsw;		/* sidewall grading coefficient		*/
   double	fcpb;		/* fc * pb				*/
};
