/* ctoi.c  94.04.20
 * Copyright 1983-1992   Albert Davis
 * get integer from string
 * update string pointer
 * return integer if got, else 0
 * pointer points to char following number just got
 * or first non-space
 */
#include "ecah.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	int	 ctoi(const char*,int*);
	unsigned ctou(const char*,int*);
	int	 ctoo(const char*,int*);
	int	 ctox(const char*,int*);
/*--------------------------------------------------------------------------*/
/* ctoi: character input to integer
 * Returns signed integer, or 0 if the string is not a number.
 * Input must be integer: no multipliers, no decimal point.
 * Dot or letter belongs to the next token.
 */
int ctoi(const char *cmd, int *cnt)
{
 int val, sign;

 skipbl(cmd,cnt);

 sign = 1;                    /* sign */
 if (cmd[*cnt]=='+'){
    (*cnt)++;
 }else if (cmd[*cnt]=='-'){
    sign = -1;
    (*cnt)++;
 }

 for (val = 0;  isdigit(cmd[*cnt]);  (*cnt)++)
    val = 10 * val + (cmd[*cnt]-'0');

 skipcom(cmd,cnt);
 return val * sign;
}
/*--------------------------------------------------------------------------*/
/* ctou: character input to unsigned integer
 * Returns unsigned integer, or 0 if the string is not a number.
 * Input must be integer: no multipliers, no decimal point.
 * Dot or letter belongs to the next token.
 */
unsigned ctou(const char *cmd, int *cnt)
{
 int val;

 skipbl(cmd,cnt);

 for (val = 0;  isdigit(cmd[*cnt]);  (*cnt)++)
    val = 10 * val + (cmd[*cnt]-'0');

 skipcom(cmd,cnt);
 return val;
}
/*--------------------------------------------------------------------------*/
/* ctoo: character octal input to integer
 * Returns integer, or 0 if the string is not a number.
 * Input must be integer: no multipliers, no decimal point.
 * Dot or letter belongs to the next token.
 * There is no check against '8' and '9'.
 */
int ctoo(const char *cmd, int *cnt)
{
 int val;

 skipbl(cmd,cnt);

 for (val = 0;  isdigit(cmd[*cnt]);  (*cnt)++)
    val = 8 * val + (cmd[*cnt]-'0');

 skipcom(cmd,cnt);
 return val;
}
/*--------------------------------------------------------------------------*/
/* ctox: character hex input to unsigned integer
 * Returns integer, or 0 if the string is not a number.
 * Input must be hex integer: no multipliers, no decimal point.
 * Dot or letter belongs to the next token.
 */
int ctox(const char *cmd, int *cnt)
{
 int val;

 skipbl(cmd,cnt);

 for (val = 0;  isxdigit(cmd[*cnt]);  (*cnt)++){
    if (isdigit(cmd[*cnt])){
       val = 16 * val + (cmd[*cnt]-'0');
    }else{
       val = 16 * val + (to_lower(cmd[*cnt])-'a'+10);
    }
 }

 skipcom(cmd,cnt);
 return val;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
