/* array.c  93.12.19
 * Copyright 1983-1992   Albert Davis
 * Access main arrays.
 * Returns pointer to the requested array element.
 * If the place is not allocated, returns pointer to a zero.
 * There are several of these, to access different arrays.
 * Robust versions, with bounds checking, of sorts.
 * For fast versions (macros) see array.h.
 */
#include "ecah.h"
#include "error.h"
#include "nodestat.h"
#include "status.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	double	*re(int,int);
	double	*im(int,int);
/*--------------------------------------------------------------------------*/
extern const struct status stats;
extern	     struct nodestuff ns;
extern double **rerow, **imrow;		/* array of row pointers	    */
extern double **recol, **imcol;		/* array of column pointers	    */
extern double **redia, **imdia;		/* array of diagonal pointers	    */
extern double zero;			/* really a constant, i hope	    */
static double trash;			/* place to deposit node 0	    */
extern const char e_int[];
/*--------------------------------------------------------------------------*/
double *re(int row,int col)
{
 if (col == row){
    return (redia[row]);
 }else if (col > row){		/* above the diagonal */
    if (row == 0)
       return &trash;
    if (col > stats.total_nodes)
       error(bERROR, e_int, "array");
    if (row < ns.basnode[col])
       return &zero;
    return (recol[col] + row);
 }else{/* if (col < row) */	/* below the diagonal */
    if (col == 0)
       return &trash;
    if (row > stats.total_nodes)
       error(bERROR, e_int, "array");
    if (col < ns.basnode[row])
       return &zero;
    return (rerow[row] - col);
 }
}
/*--------------------------------------------------------------------------*/
double *im(int row,int col)
{
 if (col == row){
    return (imdia[row]);
 }else if (col > row){		/* above the diagonal */
    if (row == 0)
       return &trash;
    if (col > stats.total_nodes)
       error(bERROR, e_int, "array");
    if (row < ns.basnode[col])
       return &zero;
    return (imcol[col] + row);
 }else{ /* if (col < row) */	/* below the diagonal */
    if (col == 0)
       return &trash;
    if (row > stats.total_nodes)
       error(bERROR, e_int, "array");
    if (col < ns.basnode[row])
       return &zero;
    return (imrow[row] - col);
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
